# Controlling Neural Networks with Rule Representations

## Requirements

### Dependencies
- `python 3.7`
- `pytorch 1.6.0`

To install requirements:

```setup
pip install -r requirements.txt
```

## Training

### Double pendulum system
- Data

The double pendulum dataset is generated in `train.py` file. Please check `pendulum-system/train.py` to see how data is generated.

- Train
```train
$ cd pendulum-systems
$ python train.py --model_type deepctrl-autoscale
```
- Evaluation

Evaluation is done after the training process.


### M5 forecasting task

- Data

For the M5 forecasting task, the original dataset is available in Kaggle https://www.kaggle.com/c/m5-forecasting-accuracy/data

We preprocess the original dataset to be suitable to verify our proposed model. The processed files are available in `m5-forecasting/data/m5-dataset.zip`.

- Train
```train
$ cd m5-forecasting
$ python train.py --model_type deepctrl
```

- Evaluation

Evaluation is done after the training process.

### Healthcare task

- Data

Task description and dataset is available in Kaggle https://www.kaggle.com/sulianova/cardiovascular-disease-dataset

We preprocess the original dataset to be suitable to domain adaptation experiments. See `healthcare/[demo] domain-adaptation.ipynb` how the original data is divided.

- Train
```train
$ cd healthcare
$ python train.py --model_type deepctrl
```

- Evaluation

Evaluation is done after the training process.

